@echo off

set OUTFILENAME=%cd%\\tempoutfile-%RANDOM%.arff
set FILENAME=tempfile-%RANDOM%.txt
set FILENAME2=tempfile-%RANDOM%.txt

CALL bin\LengthCalcFromTMHMMResults.exe %1 %OUTFILENAME% %2

IF "%2"=="1" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_all_lvl_1.arff -T %OUTFILENAME% -i > %FILENAME%
	GOTO writeResult
)

IF "%2"=="2" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_all.arff -T %OUTFILENAME% -i > %FILENAME%
	GOTO writeResult
)

IF "%2"=="3" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_all_lvl_3.arff -T %OUTFILENAME% -i > %FILENAME%
	GOTO writeResult
)

java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_all_lvl_0.arff -T %OUTFILENAME% -i > %FILENAME%

:writeResult (
	set testingFound=0
	set confusionFound=0
	set oneLinePassed=0

	setlocal disableDelayedExpansion
	FOR /F "tokens=*" %%A in (%FILENAME%) DO (
		set str=%%A
		setlocal enableDelayedExpansion
		IF !confusionFound!==1 (
			IF !oneLinePassed!==1 (
				ECHO !str! >> !FILENAME2!
				endlocal
				GOTO finishWork
			)
			endlocal
			set oneLinePassed=1
			setlocal enableDelayedExpansion
		)
		IF "!str:~0,26!"=="Time taken to build model:" (
			ECHO.
			echo !str!
			ECHO.
		)
		IF "!str:~0,26!"=="=== Error on test data ===" (
			endlocal
			set testingFound=1
			setlocal enableDelayedExpansion
		)
		IF "!str:~0,24!"=="=== Confusion Matrix ===" (
			IF !testingFound!==1 (
				endlocal
				set confusionFound=1
				setlocal enableDelayedExpansion
			)
		)
		endlocal
	)
)

:finishWork (
	CALL bin\findClass %FILENAME2% %2

	DEL %FILENAME%
	DEL %OUTFILENAME%
	DEL %FILENAME2%
)
