@echo off

set FILENAME=tempfile-%RANDOM%.txt

IF "%1"=="1" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_all.arff -i > %FILENAME%
)

IF "%1"=="2" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_sec_3_3.arff -T data\testing_sec_3_3.arff -i > %FILENAME%
)

IF "%1"=="3" (
	java -Xmx1024m -classpath "%WEKA_HOME%\weka.jar" weka.classifiers.trees.RandomForest -I 10 -K 0 -S 1 -t data\training_sec_3_4.arff -T data\testing_sec_3_4.arff -i > %FILENAME%
)

set testingFound=0

setlocal disableDelayedExpansion
FOR /F "tokens=*" %%A in (%FILENAME%) DO (
	set str=%%A
	setlocal enableDelayedExpansion
	IF "!str:~0,26!"=="Time taken to build model:" (
		ECHO.
		echo !str!
		ECHO.
	)
	IF "!str:~0,26!"=="=== Error on test data ===" (
		endlocal
		set testingFound=1
		setlocal enableDelayedExpansion
	)
	IF "!str:~0,35!"=="=== Stratified cross-validation ===" (
		endlocal
		set testingFound=1
		setlocal enableDelayedExpansion
	)
	IF "!str:~0,30!"=="Correctly Classified Instances" (
		IF !testingFound!==1 (
			echo Correctly Classified Instances:   !str:~-10!
		)
	)
	IF "!str:~0,13!"=="Weighted Avg." (
		IF !testingFound!==1 (
			echo TP rate:                           !str:~17,5!
			echo FP rate:                           !str:~27,5!
			echo Precision:                         !str:~38,5!
			echo Recall:                            !str:~48,5!
			echo F-Measure:                         !str:~58,5!
			echo ROC Area:                          !str:~69,5!
			echo.
		)
	)
	endlocal
)

DEL %FILENAME%
