@echo off

IF "%WEKA_HOME%"=="" (
	ECHO WEKA_HOME is NOT defined, exiting..
	GOTO:EOF
)

IF "%1"=="-t" GOTO typeFunc
IF "%1"=="-p" GOTO predictFunc

:usageFunc (
	ECHO Usage: GPCRsort.bat -t ^<1^|2^|3^>
	ECHO        ^<to execute experiments^>
	ECHO        ^<where 1: Cross validation experiment ^(Section 3.2^)^>
	ECHO        ^<      2: Independent dataset experiment ^(Section 3.3^)^>
	ECHO        ^<      3: Comparison with other methods experiment ^(Section 3.4^)^>
	ECHO.
	ECHO    or  GPCRsort.bat -p ^<TMHMM_result_file^> ^<depth^>
	ECHO        ^<to predict the class of an unknown GPCR^>
	ECHO        ^<where TMHMM_result_file: Result file of prediction of transmembrane helices in GPCR by TMHMM^>
	ECHO        ^<                         Output format of TMHMM must be: 'One line per protein'^>
	ECHO        ^<      depth: prediction depth in the GPCR class hierarchy^>
	ECHO        ^<             values: 0 (exact class) ^| 1 ^| 2 ^| 3^> 
	GOTO:EOF
)

:typeFunc (
	IF "%2"=="1" (
		CALL bin\experiments.bat 1
		GOTO:EOF
	)
	IF "%2"=="2" (
		CALL bin\experiments.bat 2
		GOTO:EOF
	)
	IF "%2"=="3" (
		CALL bin\experiments.bat 3
		GOTO:EOF
	)
	GOTO usageFunc
)

:predictFunc (
	IF "%2"=="" GOTO usageFunc
	IF "%3"=="" GOTO usageFunc
	CALL bin\predict.bat %2	%3
	GOTO:EOF
)
